unit IWTypes;

{PUBDIST}

interface

uses
{$IFDEF VSNET}
  System.ComponentModel, System.Drawing.Design,
{$ELSE}
  {$IFDEF Linux}QControls,{$ELSE}Controls,{$ENDIF}
{$ENDIF}
  Classes,
  SysUtils;

type
  TIWWindowOption = (
    {$IFDEF VSNET}woNone = 0,{$ENDIF}
    woButtons, woStatusBar, woMenuBar, woScrollBars, woResizable,
    woCopyHistory, woFullScreen);

  {$IFDEF VSNET}
  [EditorAttribute('Atozed.Intraweb.Design.SetEditor, Atozed.Intraweb.Design', typeof(UITypeEditor))]
  {$ENDIF}
  TIWWindowOptions = set of TIWWindowOption;

  TIWBrowser = (
{$IFDEF VSNET}
    brNone = 0, // This is used instead of zero selection in code
{$ENDIF}
    brUnknown
    // HTML 4
    , brIE, brNetscape7, brOpera, brSafari
    // HML3.2
    , brIE4, brNetscape6, brNetscape4, brOther, brHTML32Test
    // WAP browsers
    , brWMLTest, brXHTMLMPTest, brWAP // This is a generic WAP browser.
  );

  TIWFileName = {$IFDEF VSNET} string {$ELSE} TFilename {$ENDIF};

  {$IFDEF CLR}
  {$IFDEF VSNET}
  TFileName = string;
  TIWTabOrder = Integer;
  {$ELSE}
  TIWTabOrder = TTabOrder;
  {$ENDIF}
  {$ELSE}
  TIWTabOrder = TTabOrder;
  {$ENDIF}

  {$IFDEF VSNET}
  [EditorAttribute('Atozed.Intraweb.Design.SetEditor, Atozed.Intraweb.Design', typeof(UITypeEditor))]
  {$ENDIF}
  TIWBrowsers = set of TIWBrowser;

  TIWWAPOutputTagType = (wotWML, wotXHTMLMP);

  TIWClientType = (ctUnknown, ctHTML40, ctHTML32, ctWAP);

  TIWCursor = (crAuto, crCrossHair, crDefault, crPointer, crMove, crEResize,
    crNEResize, crNWResize, crNResize, crSEResize, crSWResize, crSResize, crWResize,
    crText, crWait, crHelp);

  TIWFormType = (ftUnknown, ftApp, ftPage);

  TIWFormOutput = (foUnknown, foHTML32, foHTML40, foWML, foXHTMLMP);

  TIWServerType = (stApplication, stPage);

  TIWShowMessageType = (smAlert, smNewWindow, smSameWindow, smSameWindowFrame);

  TWarningProc = procedure(const AMsg: string);

  TIWHTTPServerInitProc = procedure;

  TIWLogProcedure = procedure(const AMsg: string; const ADetailedOnly: Boolean = False) of object;
  TIWLogBytesProcedure = procedure(const ABytes: Integer) of object;

  TIWTemplateLayoutHTMLTagType = (ttIntraWeb, ttBorland);

  TIWTemplateLayoutWAPTagType = (ttwIntraWeb, ttwBorland);

  TIWUnknownTagEvent = procedure(const AName: string; var VValue: string) of object;

  TIWUnknownBrowserAction = (ub32, ubWAP, ub40, ubReject);
  
  TIWTemplateProcessEvent = procedure(var VTemplate: TStream) of object;

  TIWDirectoryName = type string;

  TIWConnectionMode = (cmAny, cmSecure, cmNonSecure);

  TIWFormUpdateMode = (umAll, umPartial);

  TIWControlEncode = (ceNone, ceMPFormData);

  // reset tab orders type
  TIWTabSortType = (stXY, stYX);

const
  IWAllHTML4Browsers: TIWBrowsers = [brIE, brNetscape6, brNetscape7, brOpera, brSafari];

implementation

end.
